/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASIMessageLogger;
import com.ibm.ras.RASLogger;
import com.ibm.ras.RASMessageEvent;
import com.ibm.ras.RASUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RASMessageLogger
extends RASLogger
implements RASIMessageLogger {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private long messageMask = 7L;
    private String component = "";
    private String organization = "";
    private String product = "";
    private String messageFile;
    private Vector suppressedKeys = new Vector();

    public RASMessageLogger() {
        this("", "");
    }

    public RASMessageLogger(String string) {
        this(string, "");
    }

    public RASMessageLogger(String string, String string2) {
        super(string, string2);
        this.isLogging = true;
    }

    public RASMessageLogger(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        super(string, string2, string6, string7);
        this.isLogging = true;
        this.setOrganization(string3);
        this.setProduct(string4);
        this.setComponent(string5);
    }

    public Hashtable getConfig() {
        Hashtable hashtable = super.getConfig();
        hashtable.put("organization", this.getOrganization());
        hashtable.put("product", this.getProduct());
        hashtable.put("component", this.getComponent());
        hashtable.put("messageMask", RASMessageEvent.maskToString(this.getMessageMask()));
        String string = this.getMessageFile();
        if (string != null) {
            hashtable.put("messageFile", string);
        }
        hashtable.put("suppressedKeys", RASUtil.vectorToString(this.suppressedKeys));
        return hashtable;
    }

    public void setConfig(Hashtable hashtable) {
        super.setConfig(hashtable);
        if (hashtable.containsKey("organization")) {
            this.setOrganization((String)hashtable.get("organization"));
        }
        if (hashtable.containsKey("product")) {
            this.setProduct((String)hashtable.get("product"));
        }
        if (hashtable.containsKey("component")) {
            this.setComponent((String)hashtable.get("component"));
        }
        if (hashtable.containsKey("messageMask")) {
            this.setMessageMask(RASMessageEvent.maskLongValue((String)hashtable.get("messageMask")));
        }
        if (hashtable.containsKey("messageFile")) {
            this.messageFile = (String)hashtable.get("messageFile");
        }
        if (hashtable.containsKey("suppressedKeys")) {
            this.suppressedKeys = RASUtil.stringToVector((String)hashtable.get("suppressedKeys"));
        }
    }

    public long getMessageMask() {
        return this.messageMask;
    }

    public void setMessageMask(long l) {
        this.messageMask = l;
        this.maskValueChanged();
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String string) {
        if (string != null) {
            this.organization = string;
        }
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String string) {
        if (string != null) {
            this.product = string;
        }
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String string) {
        if (string != null) {
            this.component = string;
        }
    }

    public String getMessageFile() {
        return this.messageFile;
    }

    public void setMessageFile(String string) {
        if (string != null) {
            this.messageFile = string;
        }
    }

    public void addSuppressedKey(String string) {
        if (string != null && !this.suppressedKeys.contains(string)) {
            this.suppressedKeys.addElement(string);
        }
    }

    public void removeSuppressedKey(String string) {
        if (string != null && this.suppressedKeys.contains(string)) {
            this.suppressedKeys.removeElement(string);
        }
    }

    public Vector getSuppressedKeys() {
        return this.suppressedKeys;
    }

    public void message(long l, Object object, String string, String string2) {
        String string3 = object.getClass().getName();
        this.msg(l, string3, string, string2, (String)null, (Object[])null);
    }

    public void message(long l, Object object, String string, String string2, Object object2) {
        Object[] objectArray = new Object[]{object2};
        String string3 = object.getClass().getName();
        this.msg(l, string3, string, string2, (String)null, objectArray);
    }

    public void message(long l, Object object, String string, String string2, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object2, object3};
        String string3 = object.getClass().getName();
        this.msg(l, string3, string, string2, (String)null, objectArray);
    }

    public void message(long l, Object object, String string, String string2, Object[] objectArray) {
        String string3 = object.getClass().getName();
        this.msg(l, string3, string, string2, (String)null, objectArray);
    }

    public void message(long l, String string, String string2, String string3) {
        this.msg(l, string, string2, string3, (String)null, (Object[])null);
    }

    public void message(long l, String string, String string2, String string3, Object object) {
        Object[] objectArray = new Object[]{object};
        this.msg(l, string, string2, string3, (String)null, objectArray);
    }

    public void message(long l, String string, String string2, String string3, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        this.msg(l, string, string2, string3, (String)null, objectArray);
    }

    public void message(long l, String string, String string2, String string3, Object[] objectArray) {
        this.msg(l, string, string2, string3, (String)null, objectArray);
    }

    public void msg(long l, Object object, String string, String string2, String string3) {
        String string4 = object.getClass().getName();
        this.msg(l, string4, string, string2, string3, (Object[])null);
    }

    public void msg(long l, Object object, String string, String string2, String string3, Object object2) {
        Object[] objectArray = new Object[]{object2};
        String string4 = object.getClass().getName();
        this.msg(l, string4, string, string2, string3, objectArray);
    }

    public void msg(long l, Object object, String string, String string2, String string3, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object2, object3};
        String string4 = object.getClass().getName();
        this.msg(l, string4, string, string2, string3, objectArray);
    }

    public void msg(long l, Object object, String string, String string2, String string3, Object[] objectArray) {
        String string4 = object.getClass().getName();
        this.msg(l, string4, string, string2, string3, objectArray);
    }

    public void msg(long l, String string, String string2, String string3, String string4) {
        this.msg(l, string, string2, string3, string4, (Object[])null);
    }

    public void msg(long l, String string, String string2, String string3, String string4, Object object) {
        Object[] objectArray = new Object[]{object};
        this.msg(l, string, string2, string3, string4, objectArray);
    }

    public void msg(long l, String string, String string2, String string3, String string4, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        this.msg(l, string, string2, string3, string4, objectArray);
    }

    public void msg(long l, String string, String string2, String string3, String string4, Object[] objectArray) {
        String[] stringArray = null;
        if (this.isLoggable(l) && !this.getSuppressedKeys().contains(string3)) {
            if (string4 == null) {
                string4 = this.getMessageFile();
            }
            if (objectArray != null) {
                stringArray = new String[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    stringArray[n] = objectArray[n].toString();
                    ++n;
                }
            }
            RASMessageEvent rASMessageEvent = new RASMessageEvent(l, string3, stringArray, string4, string, string2, this.getOrganization(), this.getProduct(), this.getComponent(), this.getServer(), this.getClient(), null);
            this.fireRASEvent(rASMessageEvent);
        }
    }

    public void textMessage(long l, Object object, String string, String string2) {
        this.textMessage(l, object, string, string2, null);
    }

    public void textMessage(long l, Object object, String string, String string2, Object object2) {
        Object[] objectArray = new Object[]{object2};
        this.textMessage(l, object, string, string2, objectArray);
    }

    public void textMessage(long l, Object object, String string, String string2, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object2, object3};
        this.textMessage(l, object, string, string2, objectArray);
    }

    public void textMessage(long l, Object object, String string, String string2, Object[] objectArray) {
        String string3 = object.getClass().getName();
        this.textMessage(l, string3, string, string2, objectArray);
    }

    public void textMessage(long l, String string, String string2, String string3) {
        this.textMessage(l, string, string2, string3, (Object[])null);
    }

    public void textMessage(long l, String string, String string2, String string3, Object object) {
        Object[] objectArray = new Object[]{object};
        this.textMessage(l, string, string2, string3, objectArray);
    }

    public void textMessage(long l, String string, String string2, String string3, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        this.textMessage(l, string, string2, string3, objectArray);
    }

    public void textMessage(long l, String string, String string2, String string3, Object[] objectArray) {
        String[] stringArray = null;
        if (this.isLoggable(l)) {
            if (objectArray != null) {
                stringArray = new String[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    stringArray[n] = objectArray[n].toString();
                    ++n;
                }
            }
            RASMessageEvent rASMessageEvent = new RASMessageEvent(l, string3, stringArray, null, string, string2, this.getOrganization(), this.getProduct(), this.getComponent(), this.getServer(), this.getClient(), null);
            this.fireRASEvent(rASMessageEvent);
        }
    }

    public void exception(long l, Object object, String string, Exception exception) {
        String string2 = object.getClass().getName();
        this.exception(l, string2, string, exception);
    }

    public void exception(long l, String string, String string2, Exception exception) {
        if (this.isLoggable(l)) {
            RASMessageEvent rASMessageEvent = new RASMessageEvent(l, null, null, null, string, string2, this.getOrganization(), this.getProduct(), this.getComponent(), this.getServer(), this.getClient(), exception);
            this.fireRASEvent(rASMessageEvent);
        }
    }

    public synchronized void maskValueChanged() {
        this.isLoggableMask = 0L;
        Enumeration enumeration = this.getHandlers();
        while (enumeration.hasMoreElements()) {
            RASIHandler rASIHandler = (RASIHandler)enumeration.nextElement();
            this.isLoggableMask |= rASIHandler.getMessageMask();
        }
        this.isLoggableMask &= this.getMessageMask();
    }
}

